﻿/*********************************************************************************
// This code is created by SimCoder Version 2021a0.5 for F28004x Hardware Target
//
// SimCoder is copyright by Powersim Inc., 2009-2021
//
// Date: May 27, 2022 00:31:46
**********************************************************************************/
#include	<math.h>
#include	"PS_bios.h"
#define	GetCurTime() PS_GetSysTimer()

#ifdef _FLASH
#pragma DATA_SECTION(PSK_SysClk, "copysections")
#endif
const Uint16 PSK_SysClk = 100;  // MHz

DefaultType fGblUDELAY1, fGblUDELAY2;

interrupt void Task_1()
{
	DefaultType	fUDELAY1, fNOT1;

	PSM_Timer1IntrEntry();
	fUDELAY1 = fGblUDELAY1;


	fNOT1 = (fUDELAY1 <= 0.3) ? 1 : 0;
	PSM_GpioSetOutput(2, fNOT1 > 0.3 ? 1 : 0);
	fGblUDELAY1 = fNOT1;
}

interrupt void Task_2()
{
	DefaultType	fUDELAY2, fNOT2;

	PSM_Timer2IntrEntry();
	fUDELAY2 = fGblUDELAY2;


	fNOT2 = (fUDELAY2 <= 0.3) ? 1 : 0;
	PSM_GpioSetOutput(3, fNOT2 > 0.3 ? 1 : 0);
	fGblUDELAY2 = fNOT2;
}

static unsigned long	tmFunFreeRunTm;
static unsigned long	tmFun3;
static unsigned long	tmFun4;

void Initialize(void)
{
	PS_SysInit(2, 20);
	PS_PwmStartStopClock(0);	// Stop Pwm Clock
	PS_TimerInit(0, 0);
	PS_PwmInit(1, 0, 1, 1.e6/(10000*1.0), ePwmUseAB, ePwmStartLow1, ePwmComplement, HRPWM_DISABLE);	// pwmNo, pinSel, waveType, period, outtype, PwmA, PWMB, UseHRPwm
	PS_PwmSetDeadBand(1, 0, 2, 3, 0, 1, 1);
	PS_PwmSetIntrType(1, ePwmNoAdc, 1, 0);
	PS_PwmSetClaIntrVector(1, CLA_TASK_1);
	PS_PwmSetTripAction(1, eTzHiZ, eTzHiZ);
	PWM_CMPA(1) = (1 + 0 - 0) / (1.0 * 1) * PWM_TBPRD(1);
	PSM_PwmStart(1);

	PS_GpioSetFunc(2, 0, eSync1Samp, eGpioOut, CPU1_NO);
	PS_GpioSetFunc(3, 0, eSync1Samp, eGpioOut, CPU1_NO);
	PS_GpioSetFunc(23, 0, eSync1Samp, eGpioOut, CLA1_NO);
	PS_GpioSetFunc(34, 0, eSync1Samp, eGpioOut, CLA1_NO);

	PS_ClaInit(1, 3);

	PS_TimerInit(1, 20000L);
	PS_TimerSetIntrVector(1, Task_1);	// set timer1 interrupt vector
	PS_TimerInit(2, 100000L);
	PS_TimerSetIntrVector(2, Task_2);	// set timer2 interrupt vector
	PS_PwmStartStopClock(3);	// Start Pwm Clock, start Timer1 and Timer2
	tmFun3 = GetCurTime();
	tmFun4 = GetCurTime();
}


void main()
{
	Initialize();
	PSM_EnableIntr();   // Enable Global interrupt INTM
	PSM_EnableDbgm();
	for (;;) {
		tmFunFreeRunTm = GetCurTime();
		if (tmFunFreeRunTm - tmFun3 > 20000000) {
			PSM_ClaForceTask(2);
			tmFun3 += 20000000;
		}
		if (tmFunFreeRunTm - tmFun4 > 50000000) {
			PSM_ClaForceTask(3);
			tmFun4 += 50000000;
		}
	}
}

